use master
GO

set nocount on 

declare @ProjectPayload01 nvarchar(max) = N'
-- DEV-94288 
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N''[dbo].[Sp_quotasreindex]'') AND type in (N''P'', N''PC''))
   DROP PROCEDURE [dbo].[Sp_quotasreindex]
'

declare @ProjectPayload02 nvarchar(max) = N'
CREATE PROCEDURE [dbo].[Sp_quotasreindex]
                @ProjectId INT,
                @userId    INT
AS   

    CREATE TABLE #respondentsToBlock
    (
    respondentid VARCHAR(10) primary key
    ) 

    CREATE TABLE #respondentsToBlockBatch
    (
    respondentid VARCHAR(10) primary key
    ) 
 
    CREATE TABLE #respondentsToUnblock
    (
    respondentid VARCHAR(10) primary key
    )

    CREATE TABLE #respondentsToUnblockBatch
    (
    respondentid VARCHAR(10) primary key
    )
 
    INSERT INTO #respondentsToBlock
    SELECT resrespondent from respondent  r WITH(NOLOCK)    
    WHERE r.ResBlocked = 0 AND EXISTS  (SELECT 1
	FROM   Quota q with(nolock) INNER JOIN Stratum s WITH(NOLOCK) ON q.QtQuotaId = s.StrQuotaId
	WHERE  q.QtStatus = 2 and s.StrRespondent = ResRespondent)
 
    INSERT INTO #respondentsToUnblock
    SELECT resrespondent from respondent  r WITH(NOLOCK)    
    WHERE r.ResBlocked = 1 AND NOT EXISTS  (SELECT 1
	FROM   Quota q with(nolock) INNER JOIN Stratum s WITH(NOLOCK) ON q.QtQuotaId = s.StrQuotaId
	WHERE  q.QtStatus = 2 and s.StrRespondent = ResRespondent)
 
    DECLARE @BatchSize INT
    SET @BatchSize = 4000

    /* Disable dialing for cases that ARE currently not blocked and ARE found in any closed strata */
    WHILE EXISTS (SELECT 1 FROM #respondentsToBlock)
    BEGIN
        DELETE TOP (@BatchSize)
        FROM #respondentsToBlock
        OUTPUT deleted.respondentid INTO #respondentsToBlockBatch  

        UPDATE Respondent 
        SET ResBlocked = 1,
            ProjectId = @ProjectId,
            ModifiedBy = @UserId,
            Modified = Getutcdate()
        WHERE resrespondent IN (SELECT respondentid FROM #respondentsToBlockBatch)

        TRUNCATE TABLE #respondentsToBlockBatch;
    END                                        

	/* Enable dialing for cases that ARE currently blocked and ARE NOT found in any closed strata */
    WHILE EXISTS (SELECT 1 FROM #respondentsToUnblock)
    BEGIN
        DELETE TOP (@BatchSize)
        FROM #respondentsToUnblock
        OUTPUT deleted.respondentid INTO #respondentsToUnblockBatch 

        UPDATE Respondent 
        SET ResBlocked = 0,
            ProjectId = @ProjectId,
            ModifiedBy = @UserId,
            Modified = Getutcdate()
        WHERE resrespondent IN (SELECT respondentid FROM #respondentsToUnblockBatch)

        TRUNCATE TABLE #respondentsToUnblockBatch;
    END                                        

	DROP TABLE #respondentsToBlock
    DROP TABLE #respondentsToBlockBatch
	DROP TABLE #respondentsToUnblock
    DROP TABLE #respondentsToUnblockBatch
'

declare @ProjectPayload03 nvarchar(max) = N'
---
--- Sp_respondentconnectquotas
---
	
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N''[dbo].[sp_respondentconnectquotas]'') AND type in (N''P'', N''PC''))
DROP PROCEDURE [dbo].[Sp_respondentconnectquotas]
'

declare @ProjectPayload04 nvarchar(max) = N'
CREATE PROCEDURE [dbo].[Sp_respondentconnectquotas]
                @ProjectId  INT,
                @Respondent VARCHAR(10),
                @Action     INT
AS
IF ( @Action = 3 )
BEGIN
    -- Reset QTOnline
    UPDATE Quota SET QtOnline = 0;
END 
ELSE 
BEGIN
    -- define the operation direction
    DECLARE  @Modifier INT;
    IF ( @Action = 1 ) SET @Modifier = 1;
    ELSE If ( @Action = 2 ) SET @Modifier = -1;

    --Fetch list of Quotas to update (force S-lock on Stratum first to avoid some deadlock)
    DECLARE @quotaIdList TABLE(QuotaId int, IncrementValue int);
    INSERT INTO @quotaIdList 
	SELECT StrQuotaId, IsNull(IncrementValue,1) * @Modifier 
	       FROM Stratum 
		   WHERE StrRespondent = @Respondent 
		   AND IncrementValue <> 0;

    --Increment or Decrement  Quota.QtOnLine for strata that the respondent belong
    UPDATE q
    SET q.QtOnLine = q.QtOnLine + IncrementValue
    FROM Quota q
    INNER JOIN @quotaIdList l ON q.QtQuotaId = l.QuotaId
    WHERE q.QtStratum > 0
END
'

declare @ProjectPayload05 nvarchar(max) = N'
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N''[dbo].[sp_RespondentConnectQuotasIdList]'') AND type in (N''P'', N''PC''))
   DROP PROCEDURE [dbo].[sp_RespondentConnectQuotasIdList]
'

declare @ProjectPayload06 nvarchar(max) = N'
CREATE PROCEDURE [dbo].[sp_RespondentConnectQuotasIdList]
    @ProjectId  INT,
    @completedSynchedIds AS [dbo].[RespondentsIdList] READONLY,
    @Action     INT
AS
IF ( @Action = 3 )
BEGIN
    -- Reset QTOnline
    UPDATE Quota SET QtOnline = 0;
END 
ELSE 
BEGIN
	DECLARE @Modifier INT;
    IF ( @Action = 1 ) SET @Modifier = 1;
    ELSE If ( @Action = 2 ) SET @Modifier = -1;

	DECLARE @quotaIdList TABLE(QuotaId int, IncrementValue int);
    INSERT INTO @quotaIdList 
	SELECT StrQuotaId, SUM((ISNULL(IncrementValue, 1) * @Modifier)) AS IncrementValue
    FROM Stratum s
    INNER JOIN @completedSynchedIds si ON si.Id = StrRespondent
	GROUP BY StrQuotaId

    -- VX_TR_Stratum does not allow QtOnLine to be less than 0
	UPDATE q
    SET q.QtOnLine = CASE WHEN QtOnLine + IncrementValue < 0 THEN 0 ELSE QtOnLine + IncrementValue END
    FROM Quota q 
    INNER JOIN @quotaIdList qid ON q.QtQuotaId = qid.QuotaId
    WHERE q.QtStratum > 0
END
'

declare @ProjectPayload07 nvarchar(max) = N'
---
--- This store procedure is made to replace the delphi code executed with ADO. 
---    From now on, the ServnoServer (vxi_Servno.dll) will call only one this whern configure to use Role
---    configuration for extraction as provider of Automatic (Pred, Non-Pred and Hybrid) telephony module.
---    With this store procedure, we also have the VX_sp_ExtractGroupPhoneNumber in case of Group configuration.
---
---Created 2014-04-15: US2333 Filter empty phoneNumber feature, inject PhoneNumber from alias feature
---Modified 2015-01-11: add ManualFilter option for TCPA compliance
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N''[dbo].[VX_sp_ExtractRolePhoneNumber]'') AND type in (N''P'', N''PC''))
DROP PROCEDURE [dbo].[VX_sp_ExtractRolePhoneNumber]
'

declare @ProjectPayload08 nvarchar(max) = N'
/****** Object:  StoredProcedure [dbo].[VX_sp_ExtractRolePhoneNumber]    Script Date: 4/15/2014 12:45:28 PM ******/
CREATE PROCEDURE  [dbo].[VX_sp_ExtractRolePhoneNumber]  
 @BrowseNbr INT                 = 100, -- Should use f(NbrLoggedAgents)
 @ProjectId INT                 = 0,
 @DialingMask INT               = 0xFF, -- Bit: NA,NA,NA,NA,NA,PV,NP,PR 
 @RoleSets VARCHAR(max)         = null, -- ''1,2,3;1,4;1,2,4'' '','' -> seperates roles, '';'' seperates roleset belonging to same group/agent
 @PhoneAlias NVARCHAR(32)       = '''',
 @OriginationPhone NVARCHAR(32) = '''',
 @ManualFilter int = null -- (null (default), 0, 1)
AS
SET NOCOUNT ON;

DECLARE @lockResult INT;
DECLARE @ErrorMessage NVARCHAR(4000);
DECLARE @ErrorSeverity INT;
DECLARE @ErrorState INT;
DECLARE @TraceId BIGINT;
DECLARE @MaxCbDate DATETIME = ''9999-12-31T00:00:00Z''

SET @TraceId = null;

EXEC @lockResult = sp_getapplock ''sp_new'', ''Exclusive'', ''Session'', 600000;

IF ( (@lockResult = 0) or (@lockResult = 1)) --- SUCCESS
BEGIN
	BEGIN TRY
		SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED;

		EXEC sp_UpdateStrataState 0, 0;

		EXEC VX_sp_FillCaseBuffer @BrowseNbr, 0, @DialingMask, 1, 0 , @RoleSets, null, @TraceId OUT, 1, @PhoneAlias,  @ManualFilter;

		CREATE TABLE #ExtractedRecords ( Respondent VARCHAR(10) PRIMARY KEY, ResCall INT, ComputeCB DATETIME, Phone NVARCHAR(100), callbackdate DATETIME, DialingMode INT, OrderKey INT, OriginationPhone NVARCHAR(100))	

		BEGIN TRY
			IF ((@OriginationPhone = '''') or @OriginationPhone IS NULL)
			BEGIN
			   INSERT INTO #ExtractedRecords 
						SELECT TOP (@BrowseNbr)
							Respondent,
							n.ResCall,
							coalesce(CASE WHEN cast(callbackdate AS INT) <10 THEN @MaxCbDate ELSE callbackdate END, @MaxCbDate) AS ComputeCB,
							Phone,
							callbackdate,
							DialingMode,
							OrderKey,
							'''' AS OriginationPhone
						 FROM buffernew n 
						 WHERE n.rescall=0
						 ORDER BY OrderKey;

			END
			ELSE
			BEGIN
				INSERT INTO #ExtractedRecords
						 SELECT TOP (@BrowseNbr)
							 Respondent,
							 n.ResCall,
							 coalesce(CASE WHEN cast(callbackdate AS INT) <10 THEN @MaxCbDate ELSE callbackdate END, @MaxCbDate) AS ComputeCB,
							 Phone,
							 callbackdate,
							 DialingMode,
							 OrderKey,
							 isnull(rps.rpscontent, '''') AS OriginationPhone
						 FROM buffernew n
						  left join response rps ON rpsquestion=@OriginationPhone
								 and rpsrespondent=respondent and rpsmention=1 and rpsmatrix=1 and rpstype=0
						 WHERE n.rescall=0
						 ORDER BY OrderKey;
			END
			
			--- update quota Online and Unused
			UPDATE quota SET qtOnline= qtOnline + valueonline, qtunused = qtunused - valueUnused 
			FROM quota inner join 
				( SELECT strquotaid, sum(stratum.IncrementValue) valueOnline , sum(CASE WHEN callbackdate <= 0 THEN stratum.IncrementValue ELSE 0 END) valueUnused 
				  FROM #ExtractedRecords inner join stratum WITH(NOLOCK) ON strrespondent = respondent 
				  GROUP BY strquotaid 
			) UsedStratum ON quota.qtquotaid = UsedStratum.strquotaid 
			WHERE qtstratum >0; 

			---we decrement the unused for the global quotas
			UPDATE quota SET qtunused = qtunused - (SELECT count(*) FROM #ExtractedRecords WHERE callbackdate <=0)
				WHERE qtstratum = 0
			
			--- we flag the respondent so that it can''t be extracted until it is called or recycled
			UPDATE Respondent  SET ResCompPredictive=1,ResCall=1, ResPreviousCallDate=ResCallbackDate,ResCallbackDate=0,projectId=@ProjectId,modifiedBy=0,modified=GETUTCDATE()
				WHERE ResRespondent in (SELECT respondent FROM #ExtractedRecords);

			--- We remove all the record from BufferNew that has been used
			DELETE FROM dbo.BufferNew WHERE Respondent in (SELECT respondent FROM #ExtractedRecords);

		SET NOCOUNT OFF;
			--- this is the return select with all the records
			SELECT DISTINCT #ExtractedRecords.* , Quota.RoleId FROM #ExtractedRecords
				  LEFT JOIN Stratum WITH (NOLOCK) ON #ExtractedRecords.Respondent = Stratum.StrRespondent
				  LEFT JOIN Quota WITH (NOLOCK) ON Stratum.StrQuotaId = Quota.QtQuotaId
				  ORDER BY OrderKey;
		SET NOCOUNT ON;
		END TRY
		BEGIN CATCH
			SELECT 
			    @ErrorMessage = ERROR_MESSAGE() + '':'' + isnull(ERROR_PROCEDURE(), ''??'') + ''('' + convert(NVARCHAR(20), ERROR_LINE()) + '')'',
				@ErrorSeverity = ERROR_SEVERITY(),
				@ErrorState = ERROR_STATE();

			DROP TABLE #ExtractedRecords;

			RAISERROR (@ErrorMessage, -- Message text.
					   @ErrorSeverity, -- Severity.
					   @ErrorState -- State.
					   );
		END CATCH

		--- We remove temporary table from the excution for the workflow of the next time we call this
		DROP TABLE #ExtractedRecords;
	END TRY
	BEGIN CATCH
		SELECT 
		    @ErrorMessage = ERROR_MESSAGE() + '':'' + isnull(ERROR_PROCEDURE(), ''??'') + ''('' + convert(NVARCHAR(20), ERROR_LINE()) + '')'',
			@ErrorSeverity = ERROR_SEVERITY(),
			@ErrorState = ERROR_STATE();

		EXEC @lockResult = sp_releaseapplock ''sp_new'', ''Session'';

		RAISERROR (@ErrorMessage, -- Message text.
				   @ErrorSeverity, -- Severity.
				   @ErrorState -- State.
				  );
		RETURN;
	END CATCH

    EXEC @lockResult = sp_releaseapplock ''sp_new'', ''Session'';
END
ELSE
BEGIN
	--- raise @lockResult and message about error on Lock sp_new
	RAISERROR (''Error in get application lock'', -- Message text.
			   -1, -- Severity.
			   0 -- State.
			  );
	RETURN;
END
'

create table #DB (
	DBName nvarchar(128),
	Processed tinyint default 0
)

declare @TotalProjectsDB int,
        @ThisProjectsDB nvarchar(128),
		@ProjectsDBCounter int = 0, 
		@ProjectsDBCursor cursor, 
		@DBSQL nvarchar(200), 
		@SQL nvarchar(max), 
		@StatusMessage varchar(max), 
		@StatusPercent tinyint

		
insert into #DB 
SELECT [name] AS DBName, 0 AS Processed FROM sys.databases WHERE [name] like 'VOXCO_Project_%';
	     
select @TotalProjectsDB = count(*) 
	    from #DB
	
set @ProjectsDBCursor = cursor scroll dynamic for select DBName from #DB for update of Processed
open @ProjectsDBCursor
fetch next from @ProjectsDBCursor into @ThisProjectsDB
while @@FETCH_STATUS = 0 begin
	select @ProjectsDBCounter += 1
	select @DBSQL = @ThisProjectsDB + N'.sys.sp_executesql'
	select @StatusMessage = 'Updating Project database "%s" (%u of %u, %u%%)', @StatusPercent = 100.0 * @ProjectsDBCounter / @TotalProjectsDB
	raiserror (@StatusMessage, 0, 1, @ThisProjectsDB, @ProjectsDBCounter, @TotalProjectsDB, @StatusPercent) with nowait
	
	SELECT 'Updating Project DB: ' + @ThisProjectsDB
        print 'Project Payload 1'
        if isnull(@ProjectPayload01, '') <> '' exec @DBSQL @ProjectPayload01

        print 'Project Payload 2'
        if isnull(@ProjectPayload02, '') <> '' exec @DBSQL @ProjectPayload02

        print 'Project Payload 3'
        if isnull(@ProjectPayload03, '') <> '' exec @DBSQL @ProjectPayload03

        print 'Project Payload 4'
        if isnull(@ProjectPayload04, '') <> '' exec @DBSQL @ProjectPayload04

        print 'Project Payload 5'
        if isnull(@ProjectPayload05, '') <> '' exec @DBSQL @ProjectPayload05

        print 'Project Payload 6'
        if isnull(@ProjectPayload06, '') <> '' exec @DBSQL @ProjectPayload06

        print 'Project Payload 7'
        if isnull(@ProjectPayload07, '') <> '' exec @DBSQL @ProjectPayload07

        print 'Project Payload 8'
        if isnull(@ProjectPayload08, '') <> '' exec @DBSQL @ProjectPayload08

	print 'All Project Payload done!'

	update #DB set Processed = 1 where current of @ProjectsDBCursor
	fetch next from @ProjectsDBCursor into @ThisProjectsDB
end

close @ProjectsDBCursor
deallocate @ProjectsDBCursor

--select * from #DB

drop table #DB

